﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt"
				xmlns:websoft="http://www.websoft.ru"
				version="1.0">
<!--
'*	nav_015_progress#.xsl
'*	Copyright (c) Websoft, 2007.  All rights reserved.
-->
<xsl:output method="xml" encoding="utf-8" omit-xml-declaration="yes"/>
<xsl:param name="objectID"></xsl:param>
<xsl:param name="imagesFolder"></xsl:param>
<xsl:param name="moduleImagesFolder"></xsl:param>
<!--		 Template: Root    -->
<xsl:template match="/">
	<xsl:apply-templates select="params"/>
</xsl:template>
<!--		 Template: Params    -->
<xsl:template match="params">
<xsl:if test="show_mouseover='yes'">
	<div>
		<xsl:attribute name="style">text-align: center; font-family: <xsl:value-of select="mouseover_font"/>; font-size: <xsl:value-of select="mouseover_font_size"/>; font-weight: <xsl:value-of select="mouseover_font_weight"/>; color: <xsl:value-of select="mouseover_font_color"/>; padding-bottom: <xsl:value-of select="mouseover_padding"/>;</xsl:attribute>
		Slide Name onMouseOver
	</div>
</xsl:if>
<div>
	<xsl:attribute name="style">background-color: <xsl:value-of select="bgcolor"/>; border-color: <xsl:value-of select="bordercolor"/>; border-width: <xsl:value-of select="borderwidth"/>; border-style: solid; padding: <xsl:value-of select="padding"/>px;</xsl:attribute>
	<table cellpadding="0" border="0" align="center">
		<xsl:attribute name="cellspacing"><xsl:value-of select="offset"/></xsl:attribute>
		<tr>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_visited_bgcolor"/>; border-color: <xsl:value-of select="el_visited_brdcolor"/>; border-width: <xsl:value-of select="el_visited_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_visited_brdwidth))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_visited_brdwidth))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n1_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_visited_bgcolor"/>; border-color: <xsl:value-of select="el_visited_brdcolor"/>; border-width: <xsl:value-of select="el_visited_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_visited_brdwidth))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_visited_brdwidth))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n1_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_current_bgcolor"/>; border-color: <xsl:value-of select="el_current_brdcolor"/>; border-width: <xsl:value-of select="el_current_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_current_brdwidth))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_current_brdwidth))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n2_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_unvisited_bgcolor"/>; border-color: <xsl:value-of select="el_unvisited_brdcolor"/>; border-width: <xsl:value-of select="el_unvisited_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n3_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_unvisited_bgcolor"/>; border-color: <xsl:value-of select="el_unvisited_brdcolor"/>; border-width: <xsl:value-of select="el_unvisited_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n3_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_unvisited_bgcolor"/>; border-color: <xsl:value-of select="el_unvisited_brdcolor"/>; border-width: <xsl:value-of select="el_unvisited_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n3_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_unvisited_bgcolor"/>; border-color: <xsl:value-of select="el_unvisited_brdcolor"/>; border-width: <xsl:value-of select="el_unvisited_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n3_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_unvisited_bgcolor"/>; border-color: <xsl:value-of select="el_unvisited_brdcolor"/>; border-width: <xsl:value-of select="el_unvisited_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n3_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_unvisited_bgcolor"/>; border-color: <xsl:value-of select="el_unvisited_brdcolor"/>; border-width: <xsl:value-of select="el_unvisited_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n3_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
			<td>
				<xsl:if test="standard='yes'">
					<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px;</xsl:attribute>
					<div>
						<xsl:attribute name="style">width: <xsl:value-of select="el_width"/>px; height: <xsl:value-of select="el_height"/>px; background-color: <xsl:value-of select="el_unvisited_bgcolor"/>; border-color: <xsl:value-of select="el_unvisited_brdcolor"/>; border-width: <xsl:value-of select="el_unvisited_brdwidth"/>px; border-style: solid;</xsl:attribute>
						<spacer>
							<xsl:attribute name="width"><xsl:value-of select="string(number(el_width)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
							<xsl:attribute name="height"><xsl:value-of select="string(number(el_height)-2*number(el_unvisited_brdcolor))"/></xsl:attribute>
						</spacer>
					</div>
				</xsl:if>
				<xsl:if test="standard='no'">
					<img border="0"><xsl:attribute name="src"><xsl:value-of select="substring-before($moduleImagesFolder,'images\')"/><xsl:value-of select="translate(n3_img,'/','\')"/></xsl:attribute></img>
				</xsl:if>
			</td>
		</tr>
	</table>
</div>
<xsl:if test="show_slidename='yes'">
	<div>
		<xsl:attribute name="style">text-align: center; font-family: <xsl:value-of select="current_font"/>; font-size: <xsl:value-of select="current_font_size"/>; font-weight: <xsl:value-of select="current_font_weight"/>; color: <xsl:value-of select="current_font_color"/>; padding-top: <xsl:value-of select="current_padding"/>;</xsl:attribute>
		<xsl:if test="show_number='yes'">1/1</xsl:if> Current Slide Name
	</div>
</xsl:if>
</xsl:template>
</xsl:stylesheet>
